<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Http\Controllers\Controller;
use App\Http\Resources\Web\ModulesResource;
use App\Http\Resources\Web\PricingPlansResource;
use App\Models\Therapist;
use App\Models\TherapistCommunity;
use App\Models\PricingPlan;
use App\Models\PricingPlanModule;
use Laravel\Cashier\Cashier;

class PricingPlansController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request, $type)
    {
        if ($type == 'therapist') {
            $pricing_plans = PricingPlan::with('modules')->therapist()->active()->get();
            $pricing_plans = PricingPlansResource::collection($pricing_plans);
            $modules = PricingPlanModule::therapist()->orderBy('sort_order', 'asc')->get();
            $modules = ModulesResource::collection($modules);
        } else if ($type == 'therapist_community') {
            $pricing_plans = PricingPlan::with('modules')->therapistCommunity()->active()->get();
            $pricing_plans = PricingPlansResource::collection($pricing_plans);
            $modules = PricingPlanModule::therapistCommunity()->orderBy('sort_order', 'asc')->get();
            $modules = ModulesResource::collection($modules);
        } else {
            $response = generateResponse(null, true, "User type noy exists", null, 'collection');
            return response()->json($response);
        }
        $data = [
            'pricing_plans' => $pricing_plans,
            'all_modules' => $modules
        ];
        $response = generateResponse($data, true, "Pricing Plans fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function show(Request $request, $type, $slug)
    {
        $settings = generalSettings();
        $user = auth()->user();
        if ($type == 'therapist') {
            $pricing_plan = PricingPlan::with('modules')->therapist()->active()->where('slug', $slug)->first();
            if ($pricing_plan) {
                $pricing_plan = new PricingPlansResource($pricing_plan);
                $modules = PricingPlanModule::therapist()->orderBy('sort_order', 'asc')->get();
                $modules = ModulesResource::collection($modules);
            } else {
                $response = generateResponse(null, true, "Pricing Plans not found", null, 'collection');
                return response()->json($response);
            }
        } else if ($type == 'therapist_community') {
            $pricing_plan = PricingPlan::with('modules')->therapistCommunity()->where('slug', $slug)->active()->first();
            if ($pricing_plan) {
                $pricing_plan = new PricingPlansResource($pricing_plan);
                $modules = PricingPlanModule::therapist()->orderBy('sort_order', 'asc')->get();
                $modules = ModulesResource::collection($modules);
            } else {
                $response = generateResponse(null, true, "Pricing Plans not found", null, 'collection');
                return response()->json($response);
            }
        }
        $data = [
            'pricing_plan' => $pricing_plan,
            'all_modules' => $modules,
        ];
        $response = generateResponse($data, true, "Pricing Plans detail fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function subscription(Request $request, $type, $slug)
    {
        $user = auth()->user();
        if ($type == 'therapist') {
            config(['cashier.model' => 'App\Models\Therapist']);
            Cashier::useCustomerModel(Therapist::class);
            $therapist = $user->therapist;
            $pricing_plan = PricingPlan::with('modules')->therapist()->where('slug', $slug)->active()->first();
            if ($pricing_plan->is_paid) {
                $subscription = $therapist->newSubscription($pricing_plan->slug, $pricing_plan->stripe_plan)->create($request->token);
                $therapist->update(['pricing_plan_id' => $pricing_plan->id]);
            } else {
                $therapist->update(['pricing_plan_id' => $pricing_plan->id]);
            }
        }
        if ($type == 'therapist_community') {
            config(['cashier.model' => 'App\Models\TherapistCommunity']);
            Cashier::useCustomerModel(TherapistCommunity::class);
            $therapist_community = $user->therapist_community;
            $pricing_plan = PricingPlan::with('modules')->therapistCommunity()->where('slug', $slug)->active()->first();
            if ($pricing_plan->is_paid) {
                $subscription = $therapist_community->newSubscription($pricing_plan->slug, $pricing_plan->stripe_plan)->create($request->token);
                $therapist_community->update(['pricing_plan_id' => $pricing_plan->id]);
            } else {
                $therapist_community->update(['pricing_plan_id' => $pricing_plan->id]);
            }
        }
        $response = generateResponse(null, true, "Successfully Activated Subscription", null, 'collection');
        return response()->json($response);
    }
}
